cordova.define("com.paidui.plugins.landicorp.Landicorp", function(require, exports, module) {

    var LandicorpLoader = function (require, exports, module) {

        var exec = require("cordova/exec");

        /**
         * Constructor.
         *
         * @returns {Landicorp}
         */
        function Landicorp() {
        };

        Landicorp.prototype.checkEnv = function(successCallback, errorCallback) {
            
            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Landicorp.checkEnv failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Landicorp.checkEnv failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'Landicorp', 'checkEnv', []);
        }

        /**
         * 打印测试
         * @param  {Function} successCallback 成功回调
         * @param  {Function} errorCallback   失败回调
         */
        Landicorp.prototype.printTest = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Landicorp.printTest failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Landicorp.printTest failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'Landicorp', 'printTest', []);
        };

        /**
         * 打印小票、台单等
         * @param  {Object} config          小票、台单格式,格式为[[{},{}],[{},{}]],多套打印票据
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        Landicorp.prototype.printTicket = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                if (config.length > 0){
                    if (!(config[0] instanceof Array)) {
                        config = [config];
                    }
                }
            } else {
                config = [];
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Landicorp.printTicket failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Landicorp.printTicket failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'Landicorp', 'printTicket', config);
        };


        /**
         * 盒子支付调用方法
         * @param  {Object} config          订单信息
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        Landicorp.prototype.payOrder = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof(config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Landicorp.payOrder failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Landicorp.payOrder failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'Landicorp', 'payOrder', config);
        };

        /**
         * 退出程序时的清理
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        Landicorp.prototype.clearOnExit = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Landicorp.clearOnExit failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Landicorp.clearOnExit failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'Landicorp', 'clearOnExit', []);
        };
        

        var Landicorp = new Landicorp();
        module.exports = Landicorp;

    }

    LandicorpLoader(require, exports, module);

    cordova.define("cordova/plugin/landicorp", LandicorpLoader);

});
