cordova.define("com.paidui.plugins.iboxpay.IBoxpay", function(require, exports, module) { 

    var IboxpayLoader = function (require, exports, module) {

        var exec = require("cordova/exec");

        /**
         * Constructor.
         *
         * @returns {Iboxpay}
         */
        function Iboxpay() {
        };

        Iboxpay.prototype.checkEnv = function(successCallback, errorCallback) {
            
            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Iboxpay.checkEnv failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Iboxpay.checkEnv failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'IBoxpay', 'checkEnv', []);
        }

        /**
         * 打印测试
         * @param  {Function} successCallback 成功回调
         * @param  {Function} errorCallback   失败回调
         */
        Iboxpay.prototype.printTest = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Iboxpay.printTest failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Iboxpay.printTest failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'IBoxpay', 'printTest', []);
        };

        /**
         * 打印小票、台单等
         * @param  {Object} config          小票、台单格式,格式为[[{},{}],[{},{}]],多套打印票据
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        Iboxpay.prototype.printTicket = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                if (config.length > 0){
                    if (!(config[0] instanceof Array)) {
                        config = [config];
                    }
                }
            } else {
                config = [];
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Iboxpay.printTicket failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Iboxpay.printTicket failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'IBoxpay', 'printTicket', config);
        };

        /**
         * 盒子认证调用方法
         * @param  {Object} config          配置信息
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        Iboxpay.prototype.authBox = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof(config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Iboxpay.authBox failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Iboxpay.authBox failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'IBoxpay', 'authBox', config);
        };

        /**
         * 盒子支付调用方法
         * @param  {Object} config          订单信息
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        Iboxpay.prototype.payOrder = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof(config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Iboxpay.payOrder failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Iboxpay.payOrder failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'IBoxpay', 'payOrder', config);
        };

        /**
         * 退出程序时的清理
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        Iboxpay.prototype.clearOnExit = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("Iboxpay.clearOnExit failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("Iboxpay.clearOnExit failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'IBoxpay', 'clearOnExit', []);
        };
        

        var Iboxpay = new Iboxpay();
        module.exports = Iboxpay;

    }

    IboxpayLoader(require, exports, module);

    cordova.define("cordova/plugin/iboxpay", IboxpayLoader);



});
