cordova.define("com.paidui.plugins.MposUtils.MposUtils", function (require, exports, module) {
    var MposUtilsLoader = function (require, exports, module) {

        var exec = require("cordova/exec");

        /**
         * Constructor.
         *
         * @returns {MposUtils}
         */
        function MposUtils() {


        };

        /**
         * alert dialog for native 
         * @param  {object} config          {title:"title", message:"jkjkj", ok:"ok", cancel:"cancel"}
         * @param  {Function} successCallback [description]
         * @param  {Function} errorCallback   [description]
         */
        MposUtils.prototype.showAlertDialog = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.showAlertDialog failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.showAlertDialog failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'showAlertDialog', config);
        };

        /**
         * ajax request for native  
         * @param  {object} config          {headers:{...}, timeout: 0, data: {...}, url:"http://xxx/xxx", type:"POST"}
         * @param  {Function} successCallback [description]
         * @param  {Function} errorCallback   [description]
         */
        MposUtils.prototype.ajax = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.ajax failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.ajax failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'ajax', config);
        };

        /**
         * load shop config
         *
         * @param {Function} successCallback 
         * @param {Function} errorCallback
         */
        MposUtils.prototype.loadShopConfig = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.loadShopConfig failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.loadShopConfig failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'loadShopConfig', config);
        };


        /**
           * load shop config
           *
           * @param {Function} successCallback 
           * @param {Function} errorCallback
           */
        MposUtils.prototype.doPrint = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.doprint failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.doprint failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'doprint', config);
        };

        /**
        * load shop config
        *
        * @param {Function} successCallback 
        * @param {Function} errorCallback
        */
        MposUtils.prototype.startSearchMagCard = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.startSearchMagCard failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.startSearchMagCard failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'startSearchMagCard', config);
        };

        /**
        * load shop config
        *
        * @param {Function} successCallback 
        * @param {Function} errorCallback
        */
        MposUtils.prototype.stopSearchMagCard = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.stopSearchMagCard failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.stopSearchMagCard failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'stopSearchMagCard', config);
        };

        /**
        * load shop config
        *
        * @param {Function} successCallback 
        * @param {Function} errorCallback
        */
        MposUtils.prototype.getMagCardNum = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.getMagCardNum failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.getMagCardNum failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'getMagCardNum', config);
        };


        /**
         * load url
         *
         * @param {Function} successCallback 
         * @param {Function} errorCallback
         */
        MposUtils.prototype.loadUrl = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof config === 'string') {
                    config = [{ ServerUrl: config }];
                } else if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.loadUrl failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.loadUrl failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'loadUrl', config);
        };

        /**
         * check url
         *
         * @param {Function} successCallback 
         * @param {Function} errorCallback
         */
        MposUtils.prototype.checkUrl = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof config === 'string') {
                    config = [{ ServerUrl: config }];
                } else if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.checkUrl failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.checkUrl failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'checkUrl', config);
        };

        /**
        * check url
        *
        * @param {Function} successCallback 
        * @param {Function} errorCallback
        */
        MposUtils.prototype.aliNfcPay = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof config === 'string') {
                    config = [{ config }];
                } else if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.alipaybynfc failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.alipaybynfc failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'alipaybynfc', config);
        };

        /**
       * check url
       *
       * @param {Function} successCallback 
       * @param {Function} errorCallback
       */
        MposUtils.prototype.alipayscanbarcode = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof config === 'string') {
                    config = [{ config }];
                } else if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.alipayscanbarcode failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.alipayscanbarcode failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'alipayscanbarcode', config);
        };

        /**
* check url
*
* @param {Function} successCallback 
* @param {Function} errorCallback
*/
        MposUtils.prototype.alipayVoice = function (config, successCallback, errorCallback) {

            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof config === 'string') {
                    config = [{ config }];
                } else if (typeof (config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.alipaybynfc failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.alipaybynfc failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'alipayvoice', config);
        };

        /**
         * 退出app的提醒
         * @param  {Function} successCallback 成功对调
         * @param  {Function} errorCallback   失败回调
         */
        MposUtils.prototype.exitApp = function (successCallback, errorCallback) {

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.exitApp failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.exitApp failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'exitApp', []);
        }

        /**
         * get mac address
         * @param  {Function} successCallback success callback
         * @param  {Function} errorCallback   error callback
         * @return {Object}                 Json object, 
         */
        MposUtils.prototype.getMacAddress = function (successCallback, errorCallback) {

            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.getMacAddress failure: failure parameter not a function");
                return;
            }
            if (typeof successCallback != "function") {
                console.log("MposUtils.getMacAddress failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'getMacAddress', []);
        }

        /**
         * get ip address
         * @param  {Function} successCallback success callback
         * @param  {Function} errorCallback   error callback
         * @return {Object}                 Json object, 
         */
        MposUtils.prototype.getIpAddress = function (successCallback, errorCallback) {
            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.getIpAddress failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.getIpAddress failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'getIpAddress', []);
        }

        /**
         * get ip mac address
         * @param  {Function} successCallback success callback
         * @param  {Function} errorCallback   error callback
         * @return {Object}                 Json object, 
         */
        MposUtils.prototype.getIpMacAddress = function (successCallback, errorCallback) {
            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.getIpMacAddress failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.getIpMacAddress failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'getIpMacAddress', []);
        }

        /**
         * get ip/mac/model/sn, {ip:"1.1.1.1", mac:"11:22:33:44:55", model: "s300", sn:"000123123123"}
         * @param  {Function} successCallback success callback
         * @param  {Function} errorCallback   error callback
         * @return {Object}                 Json object, 
         */
        MposUtils.prototype.getDeviceConfig = function (successCallback, errorCallback) {
            successCallback = successCallback || function () { };
            errorCallback = errorCallback || function () { };

            if (typeof errorCallback != "function") {
                console.log("MposUtils.getDeviceConfig failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("MposUtils.getDeviceConfig failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'MposUtils', 'getDeviceConfig', []);
        }


        var MposUtils = new MposUtils();
        module.exports = MposUtils;

    }

    MposUtilsLoader(require, exports, module);

    cordova.define("cordova/plugin/MposUtils", MposUtilsLoader);



});