cordova.define("com.paidui.plugins.UdpScanner.UdpScanner", function(require, exports, module) { 

    var ScannerLoader = function (require, exports, module) {

        var exec = require("cordova/exec");

        /**
         * Constructor.
         *
         * @returns {UdpScanner}
         */
        function UdpScanner() {

            
        };

        /**
         * Read code from scanner.
         *
         * @param {Function} successCallback This function will recieve a result object: {
         *        text : '12345-mock',    // The code that was scanned.
         *        format : 'FORMAT_NAME', // Code format.
         *        cancelled : true/false, // Was canceled.
         *    }
         * @param {Function} errorCallback
         */
        UdpScanner.prototype.scan = function (successCallback, errorCallback, config) {

            if(config instanceof Array) {
                // do nothing
            } else {
                if(typeof(config) === 'object') {
                    config = [ config ];
                } else {
                    config = [];
                }
            }

            if (errorCallback == null) {
                errorCallback = function () {
                };
            }

            if (typeof errorCallback != "function") {
                console.log("UdpScanner.scan failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("UdpScanner.scan failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'UdpScanner', 'scan', config);
        };

        

        var UdpScanner = new UdpScanner();
        module.exports = UdpScanner;

    }

    ScannerLoader(require, exports, module);

    cordova.define("cordova/plugin/UdpScanner", ScannerLoader);





});
