cordova.define("com.paidui.plugins.lklpos.LklPos", function(require, exports, module) { 

    var LklPosLoader = function (require, exports, module) {

        var exec = require("cordova/exec");

        /**
         * Constructor.
         *
         * @returns {LklPos}
         */
        function LklPos() {
        };

        LklPos.prototype.checkEnv = function(successCallback, errorCallback) {
            
            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("LklPos.checkEnv failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("LklPos.checkEnv failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'LklPos', 'checkEnv', []);
        }

        /**
         * 打印测试
         * @param  {Function} successCallback 成功回调
         * @param  {Function} errorCallback   失败回调
         */
        LklPos.prototype.printTest = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("LklPos.printTest failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("LklPos.printTest failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'LklPos', 'printTest', []);
        };

        /**
         * 打印小票、台单等
         * @param  {Object} config          小票、台单格式,格式为[[{},{}],[{},{}]],多套打印票据
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        LklPos.prototype.printTicket = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                if (config.length > 0){
                    if (!(config[0] instanceof Array)) {
                        config = [config];
                    }
                }
            } else {
                config = [];
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("LklPos.printTicket failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("LklPos.printTicket failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'LklPos', 'printTicket', config);
        };


        /**
         * 盒子支付调用方法
         * @param  {Object} config          订单信息
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        LklPos.prototype.payOrder = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof(config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("LklPos.payOrder failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("LklPos.payOrder failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'LklPos', 'payOrder', config);
        };

        /**
         * 退出程序时的清理
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        LklPos.prototype.clearOnExit = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("LklPos.clearOnExit failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("LklPos.clearOnExit failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'LklPos', 'clearOnExit', []);
        };
        

        var LklPos = new LklPos();
        module.exports = LklPos;

    }

    LklPosLoader(require, exports, module);

    cordova.define("cordova/plugin/lklpos", LklPosLoader);



});
