cordova.define("com.paidui.plugins.wangpos.WangPos", function(require, exports, module) {


    var WangPosLoader = function (require, exports, module) {

        var exec = require("cordova/exec"); 

        /**
         * Constructor.
         *
         * @returns {WangPos}
         */
        function WangPos() {
        };

        WangPos.prototype.checkEnv = function(successCallback, errorCallback) {
            
            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("WangPos.checkEnv failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("WangPos.checkEnv failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'WangPos', 'checkEnv', []);
        }

        /**
         * 打印测试
         * @param  {Function} successCallback 成功回调
         * @param  {Function} errorCallback   失败回调
         */
        WangPos.prototype.printTest = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("WangPos.printTest failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("WangPos.printTest failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'WangPos', 'printTest', []);
        };

        /**
         * 打印小票、台单等
         * @param  {Object} config          小票、台单格式,格式为[[{},{}],[{},{}]],多套打印票据
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        WangPos.prototype.printTicket = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                if (config.length > 0){
                    if (!(config[0] instanceof Array)) {
                        config = [config];
                    }
                }
            } else {
                config = [];
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("WangPos.printTicket failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("WangPos.printTicket failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'WangPos', 'printTicket', config);
        };


        /**
         * 盒子支付调用方法
         * @param  {Object} config          订单信息
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        WangPos.prototype.payOrder = function (config, successCallback, errorCallback) {
            if (config instanceof Array) {
                // do nothing
            } else {
                if (typeof(config) === 'object') {
                    config = [config];
                } else {
                    config = [];
                }
            }

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("WangPos.payOrder failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("WangPos.payOrder failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'WangPos', 'payOrder', config);
        };

        /**
         * 退出程序时的清理
         * @param  {Function} successCallback 成功后的回调
         * @param  {Function} errorCallback   失败后的回调
         */
        WangPos.prototype.clearOnExit = function (successCallback, errorCallback) {

            successCallback = successCallback || function(){};
            errorCallback = errorCallback || function(){};

            if (typeof errorCallback != "function") {
                console.log("WangPos.clearOnExit failure: failure parameter not a function");
                return;
            }

            if (typeof successCallback != "function") {
                console.log("WangPos.clearOnExit failure: success callback parameter must be a function");
                return;
            }

            exec(successCallback, errorCallback, 'WangPos', 'clearOnExit', []);
        };
        

        var WangPos = new WangPos();
        module.exports = WangPos;

    }

    WangPosLoader(require, exports, module);

    cordova.define("cordova/plugin/wangpos", WangPosLoader);



});